#!/bin/bash

# This script is used to install Dark Tails.
# It copies necessary files to their respective directories, and sets the appropriate permissions.

persistence_dir="/live/persistence/TailsData_unlocked"
autostart_dir="${persistence_dir}/dotfiles/.config/autostart"

# Make sure we are running as 'amnesia'
if test "$(whoami)" != "amnesia"
then
    echo "You must run this program as 'amnesia' user."
    exit 1
fi

# Get the directory where the current script resides
src_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Check if ${autostart_dir} contains any files and delete them if it does.
mkdir -p "${autostart_dir}"
files=$(find "$autostart_dir" -maxdepth 1 -type f)
if [ -n "$files" ] || [ -e "$autostart_dir/dark_tails" ]; then
  echo "Files found in installation directory '${autostart_dir}'. Deleting them..."
  rm -f "$files"
  rm -f "$autostart_dir/dark_tails" 2>/dev/null
fi

# Copy autostart to dotfiles directory and make scripts executable.
echo "Copying files to autostart directory '${autostart_dir}'..."
cp -af "${src_dir}/autostart/". "${autostart_dir}/"
chmod +x "${autostart_dir}/dark_tails/startup_mods.sh"
chmod +x "${autostart_dir}/dark_tails/run_dir_scripts.sh"

# Retrieve version from version-*.txt file in ${autostart_dir}/
version_file=$(find "${autostart_dir}/dark_tails/" -maxdepth 1 -type f -name "version-*.txt" | head -n 1)
version=$(echo "${version_file}" | grep -oP 'version-\K.*(?=\.txt)')

red=$(tput setaf 1)
green=$(tput setaf 2)
reset=$(tput sgr0)

echo -e "\n${green}Installed dark_tails ${version}.${reset}
If you want any scripts to run at startup put them in:
${green}${autostart_dir}/amnesia.d${reset}"

# Check for *.sh files in ${autostart_dir}/amnesia.d/
amnesia_files=$(find "${autostart_dir}/amnesia.d/" -maxdepth 1 -type f -name "*.sh")

if [ -n "$amnesia_files" ]; then
  echo -e "\n${red}Warning: The following scripts were detected, which will be executed at the next Tails startup. Please review these scripts before restarting Tails:${reset}"
  echo "${red}$amnesia_files${reset}"
fi
